/* 
* stdarg.h
*
*      Copyright 1995, The Portland Group, Incorporated.
*      All rights reserved.
*
*        THE PORTLAND GROUP, INCORPORATED PROPRIETARY INFORMATION
* This software is supplied under the terms of a license agreement
* or nondisclosure agreement with The Portland Group and may not be
* copied or disclosed except in accordance with the terms of that
* agreement.
*/

#ifndef _STDARG_H
#define _STDARG_H	

#ifdef __cplusplus
extern "C" {

extern int __builtin_va_start(...);
extern int   __builtin_va_arg_size(...);

#endif /* __cplusplus */

#if defined(__linux__)

typedef void *__gnuc_va_list;

#endif

typedef char *va_list;

#define va_start(list, param) list = (char *)__builtin_va_start(&param)

#define va_end(list)

#define va_arg(list, mode) \
    ( \
	list += (int)__builtin_va_arg_size((mode *)0), \
	*(mode *)((char *)list - __builtin_va_arg_size((mode *)0)) \
    )

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
