********************************************************************
*     Version of 11/3/98
*
*     Sample program for the ff package
*     
*     The functions j1 and j2 are defined in
*
*     A. Barroso, J. Pulido and J. C. Romao, NPB267(1986)1926
*
*     and in
*
*     J.C. Romao, S.D. Rindani and J. W. F. Valle, NPB493(1997)56
*
********************************************************************
      implicit none
      include '/usr/local/lib/ff/ff.h'
      integer i
      real*8 xm,mz,mh0
      complex*16 j1,j2,res1,res2


*****      initialization of the ff package

      call ffini


      write(*,*)
      


      xm=10.0d0
      mz=91.2d0
      do i=1,9
      xm=xm+10.d0
      mh0=70.d0
      res1=j1(mz,mh0,xm)
      res2=j2(mz,mh0,xm)
      write(*,*)xm,res1,res2
      enddo

*      call ffexi

      end


*******
      complex*16 function j2(mz,mh0,xm)

      implicit none

*      include '/usr/local/lib/ff/ff.h'

      integer ier

      complex*16 cb01,cb02, cc0, v1

      real*8 d0,xmu,xm,mz,r12,mh0

      real*8 xpi(13)



*****    choose d0 and xmu (arbitrary)

      d0= 0.15d0
      xmu=0.33d0


*****    set higgs boson mass, Z-boson mass, and r12

      r12= mh0**2
      

*****    call ff

      call ffxb0(cb01,d0,xmu,mz**2,xm**2,xm**2,ier)

*      print *,'   cb01= ',cb01

      call ffxb0(cb02,d0,xmu,r12,xm**2,xm**2,ier)

*      print *,'   cb02= ',cb02

      xpi(1)=xm**2
      xpi(2)=xm**2
      xpi(3)=xm**2
      xpi(4)=mz**2
      xpi(5)=0.d0
      xpi(6)=r12

      call ffxc0(cc0,xpi,ier)

*      print *,'   cc0= ',cc0


      v1= 1.d0 +(mz**2)/(mz**2-r12)*(cb01-cb02)+
     :    2.d0*xm*xm*cc0



*      call ffexi
      
      j2=1./2.*xm*xm/(mz*mz-r12)*v1

      return

      end


*******
      complex*16 function j1(mz,mh0,xm)

      implicit none


      integer ier

      complex*16 cc0

      real*8 d0,xmu,xm,mz,r12,mh0

      real*8 xpi(13)

*****    choose d0 and xmu (arbitrary)

      d0= 0.36d0
      xmu=0.33d0


*****    set higgs boson mass, Z-boson mass, and r12

      r12= mh0**2
      
*****    call ff


      xpi(1)=xm**2
      xpi(2)=xm**2
      xpi(3)=xm**2
      xpi(4)=mz**2
      xpi(5)=0.d0
      xpi(6)=r12

      call ffxc0(cc0,xpi,ier)


      j1= - xm*xm*cc0



*      call ffexi
      
      return

      end

***********












